<?php
/*
Plugin Name: Live Theme Editor
Description: Edit any text (Header to Footer) instantly with SweetAlert Popups.
Version: 4.0
Author: Zepisoft
*/

if ( ! defined( 'ABSPATH' ) ) exit;

// ১. ডাটাবেস থেকে সেভ করা টেক্সট পুরো পেজে রিপ্লেস করা (Buffer Optimization)
add_action('template_redirect', function() {
    if (is_admin()) return;
    ob_start(function($buffer) {
        $saved_data = get_option('lte_saved_content', []);
        if (!empty($saved_data) && is_array($saved_data)) {
            foreach ($saved_data as $original => $new_text) {
                if (!empty($original) && $original !== $new_text) {
                    $buffer = str_replace($original, $new_text, $buffer);
                }
            }
        }
        return $buffer;
    });
});

// ২. স্ক্রিপ্ট এবং স্টাইল লোড
add_action('wp_footer', function() {
    if (!current_user_can('manage_options')) return;
    
    echo '<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>';
    ?>
    <style>
        #lte-admin-bar {
            position: fixed; bottom: 30px; left: 50%; transform: translateX(-50%);
            z-index: 9999999; background: #1e1e1e; padding: 8px 15px;
            border-radius: 50px; display: flex; gap: 10px; box-shadow: 0 10px 30px rgba(0,0,0,0.5);
            border: 1px solid #444; align-items: center;
        }
        .lte-btn {
            padding: 8px 18px; border: none; border-radius: 25px; 
            cursor: pointer; font-weight: 600; font-family: sans-serif;
            transition: all 0.2s; font-size: 13px; color: white;
        }
        #lte-start { background: #007cba; }
        #lte-save { background: #1ed14b; display: none; }
        #lte-reset { background: #ff4d4d; display: none; }
        
        .lte-editing-active [contenteditable="true"]:hover {
            outline: 2px dashed #007cba !important;
            background: rgba(0, 124, 186, 0.1) !important;
        }
    </style>

    <div id="lte-admin-bar">
        <span style="color: #aaa; font-size: 12px; margin-right: 5px;">Editor:</span>
        <button id="lte-start" class="lte-btn">Start Editing</button>
        <button id="lte-save" class="lte-btn">Save Changes</button>
        <button id="lte-reset" class="lte-btn">Reset All</button>
    </div>

    <script>
    jQuery(document).ready(function($) {
        // ১. এডিট মুড চালু করা
        $('#lte-start').on('click', function() {
            Swal.fire({ title: 'Editing Enabled', icon: 'success', toast: true, position: 'top-end', timer: 2000, showConfirmButton: false });
            
            $('body').addClass('lte-editing-active');
            
            // ফুটার এবং উইজেটসহ সব টেক্সট ধরবে
            $('p, h1, h2, h3, h4, h5, h6, span, a, li, b, strong, td, .widget-title, .site-info').each(function() {
                if ($(this).children().length === 0 && $(this).text().trim().length > 1) {
                    $(this).attr('contenteditable', 'true');
                    $(this).data('original', $(this).text().trim());
                }
            });

            $(this).hide();
            $('#lte-save, #lte-reset').show();
        });

        // ২. সেভ করা
        $('#lte-save').on('click', function() {
            var updateData = {};
            $('[contenteditable="true"]').each(function() {
                var original = $(this).data('original');
                var current = $(this).text().trim();
                if(original && original !== current) {
                    updateData[original] = current;
                }
            });

            Swal.fire({ title: 'Saving...', allowOutsideClick: false, didOpen: () => { Swal.showLoading(); }});

            $.ajax({
                url: '<?php echo admin_url('admin-ajax.php'); ?>',
                type: 'POST',
                data: { action: 'lte_save_data', content_data: updateData },
                success: function() {
                    Swal.fire('Saved!', 'Changes are now permanent.', 'success').then(() => { location.reload(); });
                }
            });
        });

        // ৩. রিসেট করা (সব আগের মতো করা)
        $('#lte-reset').on('click', function() {
            Swal.fire({
                title: 'Are you sure?',
                text: "This will revert all custom text changes!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#ff4d4d',
                confirmButtonText: 'Yes, Reset!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: '<?php echo admin_url('admin-ajax.php'); ?>',
                        type: 'POST',
                        data: { action: 'lte_reset_data' },
                        success: function() { location.reload(); }
                    });
                }
            });
        });
    });
    </script>
    <?php
});

// ৩. সেভ হ্যান্ডলার
add_action('wp_ajax_lte_save_data', function() {
    if (!current_user_can('manage_options')) return;
    $new_data = $_POST['content_data'];
    $existing_data = get_option('lte_saved_content', []);
    if(is_array($new_data)) {
        $updated_data = array_merge($existing_data, array_map('stripslashes', $new_data));
        update_option('lte_saved_content', $updated_data);
    }
    wp_send_json_success();
});

// ৪. রিসেট হ্যান্ডলার
add_action('wp_ajax_lte_reset_data', function() {
    if (current_user_can('manage_options')) {
        delete_option('lte_saved_content');
        wp_send_json_success();
    }
});